/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.core.v2_1.graphics;

import com.roguewave.chart.core.v2_1.graphics.Font3D;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import java.io.Serializable;
import java.util.Vector;

public class ScaledFont3D
implements Serializable {
    Font3D font_;
    double xScale_;
    double yScale_;
    Transform3D scaleTrans_;
    public static final boolean YUP = true;
    public static final boolean YDOWN = false;

    public ScaledFont3D(Font3D font3D, double d, boolean bl) {
        this.font_ = font3D;
        double d2 = d / (double)this.font_.getHeight();
        this.yScale_ = bl ? -d2 : d2;
        this.xScale_ = d2;
        this.scaleTrans_ = Transform3D.scale(this.xScale_, this.yScale_, 1.0);
    }

    public double getMaxAscent() {
        return (double)this.font_.getMaxAscent() * this.yScale_;
    }

    public double getMaxDescent() {
        return (double)this.font_.getMaxDescent() * this.yScale_;
    }

    public double stringWidth(String string) {
        return (double)this.font_.stringWidth(string) * this.xScale_;
    }

    public Vector stringLines(String string, Point3D point3D) {
        return this.font_.stringLines(string, point3D.X(), point3D.Y(), point3D.Z(), this.xScale_, this.yScale_);
    }

    public Vector stringLines(String string, Point3D point3D, Transform3D transform3D) {
        return this.font_.stringLines(string, point3D, new Transform3D(transform3D, this.scaleTrans_));
    }

    public String toString() {
        return "font=" + this.font_ + ", yScale=" + this.yScale_ + ", xScale=" + this.xScale_;
    }
}

